function [Step_disp,delta,X_tst,Y_tst,T,X_est,Y_est,PZT_num,Req_dir,PRCNTG_E,Tm,freq,Selc_dir,Tst_t,Min_Thresh_Max,Failed_tst,Save_Cells,XY_err,fm_Tst_t,Pred_Disp,Decision_num]...
    =Testing_FMs_DM(NI_daq_session,i,core,X,Y,File_N,X_final,Y_final,Postion_Err,PZT_num,fm_Tst_t,delta,Tm,Step_disp,X_tst,Y_tst,PRCNTG_E,Failed_tst,Save_Cells,Min_Thresh_Max,Tst_t,...
    Pred_Disp,XYF_learn,fail_point,NoTst)

% The aim of this function is to measure the lateral forces ( examine 
% all available frequency modes) by applying number of lateral modes for only
% short time and determine best force to apply based on the required
% direction. There is two conditions to perform the forces measurement stage, 
% first: particle is away from the target by greater than 50 pixels, and
% second: the previous shifted displacement is greater than 50 pixels.

my_dir='F:\SteeringControl\Steer ('; % specify the steering file

% calculation of the desired direction using two points(current & final point)
Delta_x=X_final-X;
Delta_y=Y_final-Y;
Req_dir = wrapTo2Pi(atan2(Delta_y,Delta_x));% desired direction
% keep the starting position before moving the particle for testing
X_stp=X;Y_stp=Y;
Destination=sqrt(Delta_x^2+Delta_y^2);% target distance 


if  NoTst==0 && Destination >= 50 %two conditions to perform tesing stage

%%% applying five lateral frequencies for milliseconds testing time %%%

% initial temporary matrices.
Step_disp=[];delta=[];X_tst=[];Y_tst=[];Tm=[];PRCNTG_E=[];Failed_tst=[];Save_Cells=[];

% Calculate the optimum displacement during the measuring/testing stage based on position error

% minimum and maximum error threshold where this value corresponds to 100% 
Err_thresh_Max=0.5;% 50% position error
Err_thresh_Min=0.1;% 10% position error

% minimum/maximum allowable displacement (pixels) during test step to ensure 
% forces measurement error is less/greater than err_thresh_max/min percentage
   Error_Pos_Max= Postion_Err/Err_thresh_Max; %(lower limit displacement) 
   Error_Pos_Min= Postion_Err/Err_thresh_Min; %(higher limit displacement)
   
   optimum_displacement=(Error_Pos_Max+Error_Pos_Min)/2; %(optimum displacement)
   Min_Thresh_Max=[Error_Pos_Min optimum_displacement Error_Pos_Max];
   
for fm=1:5 % corresponds to five lateral modes 
    % initial temporary variables. 
    all_done=0;  Bad_Freq=0; Bad_fm=0;
     initial_Tst_t=0.1; %initial testing time before applying fitting.
     [~,initial_Tst_t]=TM_fitting(initial_Tst_t);Tm_fit_repeat=1;
     B1=fm_Tst_t(fm,1);% first bit is the fm sequence number
     B2=fm_Tst_t(fm,2);% second bit is the modified testing time if the previous displacement is out of limits
         
     if B1==1 % if the testing time is already modified and saved with On state.
         Tst_t=B2;% apply the new assigned testing time for this turn.  
     else 
         Tst_t=initial_Tst_t;% apply the initial assigned testing time for this turn. 
     end 

     while (all_done==0) %this while loop run untill geting a reasonable displacement for the current frequency mode 
           Freq(fm).name = (['Fm',num2str(fm),]);
           
           if Bad_Freq==3 % if this frequency mode is repeated twice and the dispalcement is still lower than the limit
              Failed_tst=[Failed_tst; i fm PZT_num];
              Dir=Req_dir+3.14;% to avoid this bad frequncy mode, set direction to 180 degree away from the required one.
              
              % failed frequency mode and all relevant information to be recorded
              Step_disp=[Step_disp Disp];
              delta=[delta Dir];
              X_tst=[X_tst XX];
              Y_tst=[Y_tst YY];
              Tm=[Tm Tst_t];
              Prcntg_E=(Postion_Err/Disp)*100;
              PRCNTG_E=[PRCNTG_E Prcntg_E];
              X=XX;Y=YY;% position reverse assignment to search particle for next step.  
              all_done=1;% terminate while loop for the current frequency mode
              imwrite(img,[my_dir,num2str(File_N),')\img(',num2str(ind),').jpg']);% save failed frequency image.
              Bad_fm=1;
              Freq(fm).step=i;
              Freq(fm).force=Disp;
              Freq(fm).dir=Dir;
              Freq(fm).Prcntg_E=Prcntg_E;
              Freq(fm).X_tst=XX;
              Freq(fm).Y_tst=YY;
              Freq(fm).Tm=Tst_t;
              Freq(fm).PZT=PZT_num; 
              Freq(fm).Bad_fm=Bad_fm;
              TST_FRQ_STP={ Freq(fm).name Freq(fm).step  Freq(fm).force...
                  Freq(fm).dir  Freq(fm).X_tst Freq(fm).Y_tst Freq(fm).Prcntg_E...
                  Freq(fm).Tm  Freq(fm).PZT Freq(fm).Bad_fm};% save all frequency parameters in cell structure
              Save_Cells=[Save_Cells; TST_FRQ_STP];
                                 
              
              break % break while loop
           else
               if Tm_fit_repeat==0 % make sure testing time is fitted
               [~,Tst_t]=TM_fitting(Tst_t);
               end
                
               Driving_condition(NI_daq_session,Tst_t,fm,PZT_num); % apply this frequncy mode for a testing time Tst_t  
                
               pause(0.005);%this time delay to ensure completing the required time to the PZT before require image. 
               ind=fm+i*1000; % internal index for the this frequncy mode
               img = Snap_Image(core);% snap an image               
               [XX,YY]=Find_Bead(img,100,X,Y);% find the shifted particle
                
               Disp =sqrt((YY-Y)^2+(XX-X)^2);   % calculate displacement  
               
               if (Disp > Error_Pos_Min) % if too big displacement only modify testing time for the next turn
                   Tst_t=optimum_displacement*Tst_t/Disp;
                   if (Tst_t < initial_Tst_t)
                       Tst_t=initial_Tst_t;
                   end
                   fm_Tst_t(fm, 1)=1;fm_Tst_t(fm, 2)=Tst_t;% assign new modified testing time for this particlar fm to be used next measuring time
                   
                  
               end
               if (Disp < Error_Pos_Max) % if too small displacement modify testing time and repeat testing the same frequency mode.
                  Tst_t=optimum_displacement*Tst_t/Disp;
                  if Tst_t > 2 % testing time must not be greater than 2 seconds
                    Tst_t=2;
                  end
                  X=XX;Y=YY;% position reverse assignment only for fm loop.
%                  
                  imwrite(img,[my_dir,num2str(File_N),')\img(',num2str(ind),').jpg']);% save failed image.( if not overwritten )
                  Bad_Freq=Bad_Freq+1 ;% increase testing time repeating indicator
                     
                   
               else % the displacement for this mode is reasonable and can be taken into account for selecting forces later on. 
                           Step_disp=[Step_disp Disp];
                           Dir= wrapTo2Pi(atan2((YY-Y),(XX-X)));
                           delta=[delta Dir];
                           X_tst=[X_tst XX];
                           Y_tst=[Y_tst YY];
                           Tm=[Tm Tst_t];
                           Prcntg_E=(Postion_Err/Disp)*100;
                           PRCNTG_E=[PRCNTG_E Prcntg_E];
                           X=XX;Y=YY;% position reverse assignment to search particle for next step.  
                           all_done=1;% terminate while loop for the current frequency mode
                           imwrite(img,[my_dir,num2str(File_N),')\img(',num2str(ind),').jpg']);% save seccussful frequency image.(overwrite any failed ones)
                           Bad_fm=0;
                           Freq(fm).step=i;
                           Freq(fm).force=Disp;
                           Freq(fm).dir=Dir;
                           Freq(fm).Prcntg_E=Prcntg_E;
                           Freq(fm).X_tst=XX;
                           Freq(fm).Y_tst=YY;
                           Freq(fm).Tm=Tst_t;
                           Freq(fm).PZT=PZT_num;  
                           Freq(fm).Bad_fm=Bad_fm;
                           TST_FRQ_STP={[Freq(fm).name] [Freq(fm).step]  [Freq(fm).force]  [Freq(fm).dir]  [Freq(fm).X_tst] [Freq(fm).Y_tst] [Freq(fm).Prcntg_E]...
                               [Freq(fm).Tm] [Freq(fm).PZT] [Freq(fm).Bad_fm]};% save all frequency parameters in cell structure
                           Save_Cells=[Save_Cells; TST_FRQ_STP];              
              end % end loop for too small displacement    
              
           end %loop of (if Bad_Freq==3)       
             Tm_fit_repeat=0;                             
     end % while loop

     
end % loop for 5 frequncy modes
end
        

            
                
            display('(DM is applied)');Decision_num=5;
            %%%%%%%%%% fail piont to update forces in the main matrix XYF_learn %%%%%
             % XYF_learn=[i X(i) Y(i) Disp Dir T fm fail_point];
            if fail_point==1 %XYF_learn(8)==1
            Step_disp(XYF_learn(7))=XYF_learn(4);%update fm step with new step
            delta(XYF_learn(7))=XYF_learn(5);%update fm direction with new one
            Tm(XYF_learn(7))=XYF_learn(6);%update fm testing time with new one
            end  
        
            [~, freq]=min(abs(wrapToPi(Req_dir-delta)));% selected frequency mode (by delta matrix order)
            Selc_dir=delta(freq); % return the selected force direction
            
            % calculation of Destination distance again using two points(current &
            % final point) where particle position will change durring testing phase.
            Destination=sqrt(Delta_x^2+Delta_y^2);
            if Destination <= 100 % target distance should be less than 100 pixels
                Pred_disp=Destination/2; % decrease the shifting step by half target distance.
            else % away from the target, two options for shifting step size
                Dir_def=abs(wrapToPi(Req_dir-Selc_dir));
                if  Dir_def > 0.5 % considering only bad direction (not magnitude)
                    Pred_disp=25;
                else                    
                    Pred_disp=50;
                end
            end
            
            
            
            T=(Tm(freq)*Pred_disp)/Step_disp(freq);% activation time
            if T > 2 % activation time must not be greater than 2 seconds
               T=2;
            end
            [Xdisp,Ydisp] = pol2cart(Selc_dir,Pred_disp);
            X_est=Xdisp+X; Y_est=Ydisp+Y; % next estimated position
            
            X_err=X_stp-X; Y_err=Y_stp-Y;
            XY_err=sqrt(X_err^2+Y_err^2);% distance between starting and last testing position 
            Pred_Disp=[Pred_Disp Pred_disp]; % save predicted displacement

            
end %destination condition for repeating tesing stage.

 
 
 




   
    